//
//  SubForm03ViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/07/05.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "SubForm03ViewController.h"

@interface SubForm03ViewController ()

@end

@implementation SubForm03ViewController

@synthesize objLib = mObjLib;
@synthesize strPrtName = mStrPrtName;
@synthesize txtExtendNo;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];
    
    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    
    return self;
}

-(void) setStatusView : (int) i_Status
{
    for(int index = 0; index <= 7; index++)
    {
        UILabel* objLbl = [lblBitArray objectAtIndex:index];
        double checkNum = pow(2, index);
        
        if((i_Status & (int)checkNum) == checkNum)
        {
            objLbl.textColor = [UIColor redColor];
        }
        else
        {
            objLbl.textColor = [UIColor blackColor];
        }
    }
    
}

-(void) appClose
{
    [self timerStop:@"NGetStatus"];
    [mObjLib NClosePrinters];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    flgTimer = false;
    
    [self btnViewSetting:btnNGetStatus];
    [self btnViewSetting:btnNGetInformation];
    [self btnViewSetting:btnBack];
    
    txtExtendNo.delegate = self;
    txtExtendNo.tag = 1;
    
    nmsFrameWidth   = [[UIScreen mainScreen]applicationFrame].size.width;
    nmsFrameHeight  = [[UIScreen mainScreen]applicationFrame].size.height + 100;
    
//    NSLog(@"nmsFrameWidth:%d",nmsFrameWidth);
//    NSLog(@"nmsFrameHeight:%d",nmsFrameHeight);
    
    // UIPickerView
    pickerExtendNo = [[UIPickerView alloc] init];
    pickerExtendNo.frame = CGRectMake(0, nmsFrameHeight, nmsFrameWidth, 216);
    pickerExtendNo.showsSelectionIndicator = YES;

    pickerExtendNo.delegate = self;
    pickerExtendNo.dataSource = self;
    pickerExtendNo.tag = 1;
    
    pickerExtendNo.backgroundColor = [UIColor colorWithRed:0.89 green:0.93 blue:1.00 alpha:1.0];
    
    [self.view addSubview:pickerExtendNo];
    
    // UIToolBar
    toolBarHide = [[UIToolbar alloc] initWithFrame:CGRectMake(0,nmsFrameHeight,nmsFrameWidth,30)];
    
    UIBarButtonItem* spacer = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemFlexibleSpace target:self action:nil];
    
    UIBarButtonItem* doneButton = [[UIBarButtonItem alloc]
                                           initWithTitle:@"close"
                                           style:UIBarButtonItemStyleBordered
                                           target:self
                                           action:@selector(done:)];
    
    // only iOS7
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        [doneButton setTintColor:[UIColor whiteColor]];
    }
    
    toolBarHide.items = [NSArray arrayWithObjects:spacer,doneButton,nil];
    toolBarHide.barStyle = UIBarStyleBlack;
    
    [self.view addSubview:toolBarHide];

   
    
    
        
    flgPickerView = false;
    
    lblBitArray = [NSArray arrayWithObjects:lblBit0,lblBit1,lblBit2,lblBit3,lblBit4,lblBit5,lblBit6,lblBit7, nil];
    
    
    
    formatter = [[NSDateFormatter alloc]init];
    [formatter setDateFormat:@"yyyy/MM/dd HH:mm:ss"];
    
    // App close setting(Enter backgroud)
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appClose)
                                                 name:UIApplicationDidEnterBackgroundNotification object:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    if(textField.tag == 1)
    {
        if(!flgPickerView)
        {
            [self showPickerExtendNo];
            flgPickerView = true;
        }
        else
        {
            [self hidePicker];
            flgPickerView = false;
        }
    }
    return NO;
}

-(void) showPickerExtendNo
{
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:0.2];
    [UIView setAnimationDelegate:self];
    pickerExtendNo.frame = CGRectMake(0, 264, nmsFrameWidth, 216);
    toolBarHide.frame = CGRectMake(0,237,nmsFrameWidth,30);
    [UIView commitAnimations];
}

-(void)done:(id)sender
{
    [self hidePicker];
    flgPickerView = false;
}

-(void) hidePicker
{
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationDuration:0.2];
    [UIView setAnimationDelegate:self];
    pickerExtendNo.frame = CGRectMake(0, nmsFrameHeight, nmsFrameWidth, 216);
    toolBarHide.frame = CGRectMake(0,nmsFrameHeight,nmsFrameWidth,30);
    [UIView commitAnimations];
}

-(NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}

-(NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return 31;
}

-(NSString*)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    NSArray* arr = [[NSArray alloc] initWithObjects:
                    @"1",@"2",@"3",@"4",@"5",
                    @"6",@"7",@"8",@"9",@"10",
                    @"11",@"12",@"13",@"14",@"15",
                    @"16",@"17",@"18",@"19",@"20",
                    @"21",@"22",@"23",@"24",@"25",
                    @"26",@"27",@"28",@"29",@"30",
                    @"31",nil];
    strPick = [NSString stringWithFormat:@"%@", [arr objectAtIndex:row]];
    return strPick;
}

-(void) pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    NSArray* arr = [[NSArray alloc] initWithObjects:
                    @"1",@"2",@"3",@"4",@"5",
                    @"6",@"7",@"8",@"9",@"10",
                    @"11",@"12",@"13",@"14",@"15",
                    @"16",@"17",@"18",@"19",@"20",
                    @"21",@"22",@"23",@"24",@"25",
                    @"26",@"27",@"28",@"29",@"30",
                    @"31",nil];
    
    strPick = [NSString stringWithFormat:@"%@", [arr objectAtIndex:row]];
    txtExtendNo.text = strPick;
}

-(void) timerStop : (NSString*) strMsg
{
    [objTimer invalidate];
    flgTimer = false;
    [btnNGetStatus setTitle:strMsg forState:UIControlStateNormal];
}

-(void) repeatStatus : (NSTimer*) timer
{
    int nmsRet = 0;
    int o_status = 0;
    
    // comment:NPI NGetStatus
    nmsRet = [mObjLib NGetStatus:mStrPrtName :&o_status];
   
    // status view set
    [self setStatusView: o_status];
    
    [self setReturnCode:nmsRet];
    
    if(nmsRet != N_SUCCESS)
    {
        [self timerStop : [NSString stringWithFormat:@"NGetStatus error stop result:%d",o_status]];
    }
}


- (IBAction)pushBtnNGetStatus:(UIButton *)sender
{
    if(!flgTimer)
    {
        flgTimer = true;
        [btnNGetStatus setTitle:@"Auto status stop" forState:UIControlStateNormal];
        [btnNGetStatus setTitleColor:[UIColor redColor] forState:UIControlStateNormal];
        
        // timer start
        objTimer = [NSTimer scheduledTimerWithTimeInterval:0.5f target:self selector:@selector(repeatStatus:) userInfo:nil repeats:YES];
    }
    else
    {
        // timer stop
        [self timerStop : @"NGetStatus"];
    }
}

- (IBAction)pushBtnNGetInformation:(UIButton *)sender
{
    int nmsRet              = 0;
    int i_id                = 0;
    int io_jobid            = 0;
    NSMutableData* o_dat    = [NSMutableData data];
    UInt64 o_time           = 0;
    
    Byte rawSendCmd[3];
    
    NSString* strExtendNo = [txtExtendNo text];
    i_id = [strExtendNo intValue];
    
    // get start time
    UInt64 startTime = [self getUnixTime];
    
    // Send
    rawSendCmd[0] = 0x1B;
    rawSendCmd[1] = 0x73;
    rawSendCmd[2] = [[txtExtendNo text] intValue];
    
    // comment:NPI NDPrint(get printer information)
    nmsRet = [mObjLib NDPrint: mStrPrtName :[NSData dataWithBytes:rawSendCmd length:3]: 3 :&io_jobid];
    if(nmsRet != N_SUCCESS)
    {
        [self setReturnCode:nmsRet];
        return;
    }
        
    UInt64 checkTime = [self getUnixTime];
    while(checkTime + 3000 > [self getUnixTime])
    {
        // comment:NPI NGetInformation
        nmsRet = [mObjLib NGetInformation:mStrPrtName :i_id :o_dat : &o_time];
        if(nmsRet != N_SUCCESS)
        {
            [self setReturnCode:nmsRet];
            return;
        }
        
        if(startTime < o_time)
        {
            break;
        }
        
        [NSThread sleepForTimeInterval:0.050];
    }
    
    if(startTime >= o_time)
    {
        // Timeout
        txtResult.text  = @"Result : Timeout";
        txtDate.text    = @"";
        txtExData1.text = @"";
        txtExData2.text = @"";
        txtExData3.text = @"";
        txtExData4.text = @"";
        return;
    }
    
    if(o_dat != nil)
    {
        NSUInteger numLength = [o_dat length];
        
        if(numLength > 0)
        {
            Byte* rawData = (Byte*)malloc(numLength);
            memcpy(rawData, [o_dat bytes], numLength);
            
            // 画面に表示
            txtExData1.text = @"";
            txtExData2.text = @"";
            txtExData3.text = @"";
            txtExData4.text = @"";
            
            
            int checkCount = 0;
            NSMutableString* strLine = [NSMutableString string];
            for(int n=0; n < numLength; n++)
            {
                [strLine appendFormat:@"%02X ", rawData[n]];
                
                switch(n)
                {
                    case 15:
                        txtExData1.text = strLine;
                        strLine = [NSMutableString string];
                        checkCount++;
                        break;
                    case 31:
                        txtExData2.text = strLine;
                        strLine = [NSMutableString string];
                        checkCount++;
                        break;
                    case 47:
                        txtExData3.text = strLine;
                        strLine = [NSMutableString string];
                        checkCount++;
                        break;
                    case 63:
                        txtExData4.text = strLine;
                        strLine = [NSMutableString string];
                        checkCount++;
                        break;
                }
            }
            
            if(![strLine isEqualToString:@""])
            {
                switch(checkCount)
                {
                    case 0:
                        txtExData1.text = strLine;
                        break;
                    case 1:
                        txtExData2.text = strLine;
                        break;
                    case 2:
                        txtExData3.text = strLine;
                        break;
                    case 3:
                        txtExData4.text = strLine;
                        break;
                }
            }
            
            free(rawData);
        }
    }

    if(o_time != 0)
    {
        NSTimeInterval interval = o_time / 1000;        // ms -> sec
        NSDate* exDate = [NSDate dateWithTimeIntervalSince1970:interval];
        
        txtDate.text = [NSString stringWithFormat:@"Date : %@",[formatter stringFromDate:exDate]];
        txtResult.text = @"Result : OK";
    }

        
    [self setReturnCode:nmsRet];
    
}

-(UInt64) getUnixTime
{
    return (UInt64)floor((CFAbsoluteTimeGetCurrent() + kCFAbsoluteTimeIntervalSince1970) * 1000.0);
}

- (IBAction)pushBtnBack:(UIButton *)sender
{
    // timer stop
    [self timerStop : @"NGetStatus"];
    
    [self dismissViewControllerAnimated:YES completion:nil];
}


@end
